<?php
/**
 * XenForo Add-on Merge Double User Post
 *
 * @category XenForo Add-on
 * @package    XfRu_MergeDoubleUserPost
 * @copyright  Copyright (c) 2010 XF-Russia. (http://www.xf-russia.ru)
 * @license
 * @version   $Id: Thread.php 59 2010-12-17 22:45:41Z pepelac $ $Date: 2010-12-17 23:45:41 +0100 (Fri, 17 Dec 2010) $ $Revision: 59 $
 * @author Pepelac
 *
 */

class XfRu_MergeDoubleUserPost_ControllerPublic_Thread extends XFCP_XfRu_MergeDoubleUserPost_ControllerPublic_Thread
{
	private $threadModel;
	private $postModel;
	
	public function actionAddReply()
	{
		$this->_assertPostOnly();

		if ($this->_input->inRequest('more_options'))
		{
			return $this->responseReroute(__CLASS__, 'reply');
		}

		$this->threadModel = $this->getModelFromCache('XenForo_Model_Thread');
		$this->postModel = $this->getModelFromCache('XenForo_Model_Post');

		$threadId = $this->_input->filterSingle('thread_id', XenForo_Input::UINT);
		$thread = $this->threadModel->getThreadById($threadId);

		$visitor = XenForo_Visitor::getInstance();
		$userId = $visitor->getUserId();

		$now = time();
		$xfOptions = XenForo_Application::get('options');

		$tooOldOrOff = ($xfOptions->XfRu_DPP_TimeInterval < ($now - $thread['last_post_date'])) || $xfOptions->XfRu_DPP_TimeInterval == 0;

		$postId = $thread['last_post_id'];

		$ftpHelper = $this->getHelper('ForumThreadPost');
		list($post, $thread, $forum) = $ftpHelper->assertPostValidAndViewable($postId);

		if ($this->isExcluded($visitor, $forum, $xfOptions) || $userId != $thread['last_post_user_id'] || $tooOldOrOff)
		{
			return parent::actionAddReply();
		}

		$newMessage = $this->getHelper('Editor')->getMessageText('message', $this->_input);

		if (empty($newMessage))
		{
			// show empty message error
			return $this->responseError(new XenForo_Phrase('please_enter_valid_message'));
		}

		$newMessage = XenForo_Helper_String::autoLinkBbCode($newMessage);

		if ($xfOptions->XfRu_DPP_SendAlert)
		{
			$postedMessage = $newMessage;
		}

		$this->_assertCanEditPost($post, $thread, $forum);

		$bbCodeParser = new XenForo_BbCode_Parser(XenForo_BbCode_Formatter_Base::create('Wysiwyg'));

		$postMessage = $post['message'];
		if ($postMessage !== '')
		{
			$postMessageHtml = $bbCodeParser->render($postMessage);
		}

		$delim = '';
		if ($xfOptions->XfRu_DPP_Timestamp_Spacer)
		{
			$delim = '[MERGETIME="'.$now.'"][/MERGETIME]';
		}

		$newMessage = $bbCodeParser->render($newMessage);
		$newMessage = $postMessageHtml.$delim.$newMessage;

		$_POST['message_html'] = $newMessage;
		$_POST['post_id'] = $postId;

		$input = $this->_input->filter(array(
			'attachment_hash' => XenForo_Input::STRING,
			'watch_thread_state' => XenForo_Input::UINT,
			'watch_thread' => XenForo_Input::UINT,
			'watch_thread_email' => XenForo_Input::UINT
		));
		$input['message'] = $this->getHelper('Editor')->getMessageText('message', $this->_input);
		$input['message'] = XenForo_Helper_String::autoLinkBbCode($input['message']);

		$dw = XenForo_DataWriter::create('XenForo_DataWriter_DiscussionMessage_Post');
		$dw->setExistingData($postId);
		$dw->set('message', $input['message']);
		if ($xfOptions->XfRu_DPP_UpdatePostDate)
		{
			// update post date
			$dw->set('post_date', $now);
		}
		$dw->setExtraData(XenForo_DataWriter_DiscussionMessage::DATA_ATTACHMENT_HASH, $input['attachment_hash']);
		$dw->save();

		if ($xfOptions->XfRu_DPP_SendAlert)
		{
			// we need to send alerts
			$savedPost = $dw->getMergedData();
		    // some kind of trick to set only those quoted users, which are in new post
			$savedPost['message'] = $postedMessage;
		    // alert any members who are directly quoted by this post
			$quotedMembers = $this->postModel->alertQuotedMembers($savedPost);

			if  (!$dw->isDiscussionFirstMessage())
			{
				// notify members watching this thread, unless they are already notified of being quoted
				$this->getModelFromCache('XenForo_Model_ThreadWatch')->sendNotificationToWatchUsersOnReply($savedPost, null, $quotedMembers);
			}

		}

		if ($xfOptions->XfRu_DPP_UpdatePostDate)
		{
			// update last post date
			$threadWriter = XenForo_DataWriter::create('XenForo_DataWriter_Discussion_Thread');
			$threadWriter->setExistingData($thread['thread_id']);
			$threadWriter->bulkSet(array('last_post_date' => $now));
			$threadWriter->save();
		}

		$this->getModelFromCache('XenForo_Model_ThreadWatch')->setVisitorThreadWatchStateFromInput($thread['thread_id'], $input);

		return $this->responseRedirect(
			XenForo_ControllerResponse_Redirect::SUCCESS,
			XenForo_Link::buildPublicLink('posts', $post)
		);

	}

	protected function _assertCanEditPost(array $post, array $thread, array $forum)
	{
		if (!$this->postModel->canEditPost($post, $thread, $forum))
		{
			throw $this->getErrorOrNoPermissionResponseException(''); // @todo - message
		}
	}

	private function isExcluded(&$visitor, &$forum, &$xfOptions)
	{
		if ($this->isExcludedForum($forum['node_id'], $xfOptions->XfRu_DPP_Timestamp_Forums_Exclude))
		{
			return true;
		}

		if ($this->isExcludedUserGroup($visitor, $xfOptions->XfRu_DPP_Timestamp_Usergroup_Exclude))
		{
			return true;
		}

	    return false;
	}

	private function isExcludedUserGroup(&$visitor, $excludedGroups)
	{
		$excludedGroups = $this->strToArray($excludedGroups);
		$groups = array($visitor['user_group_id'], $visitor['secondary_group_ids']);
		$userGroups = trim(implode(',', $groups), ',');
		unset($groups);
		$userGroups = explode(',', $userGroups);
		if (!empty($excludedGroups))
		{
			foreach ($userGroups as $g)
			{
				$g = (int)$g;
				if (in_array($g, $excludedGroups))
				{
					return true;
				}
			}
		}
		return false;
	}

	private function isExcludedForum($forumId, $excludedForums)
	{
		$excludedForums = $this->strToArray($excludedForums);
		if (!empty($excludedForums) && in_array($forumId, $excludedForums))
		{
			return true;
		}
		return false;
	}

	private function strToArray($string)
	{
		$string = str_replace(' ', '', $string);
		$string = trim($string, ',');
		$string = explode(',', $string);

		$values = array();
		foreach ($string as $v)
		{
			$v = (int)$v;
			if ($v)
				$values[] = $v;
		}
		return $values;
	}
}